﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class LayoutBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Layouts GetItem(Guid TableID)
        {
            return LayoutsDB.GetItem(TableID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<Layouts> GetList(Guid TableID)
        {
            return LayoutsDB.GetList(TableID);
        }

       
        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(Layouts TableItem)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                LayoutsDB.Save(TableItem);

                myTransactionScope.Complete();
                return true;
            }
        }

        public static bool Delete(Guid TableID)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                LayoutsDB.Delete(TableID);

                myTransactionScope.Complete();
                return true;
            }
        }

    }
}
